/*
 * BT Coex module interface
 *
 * Copyright (C) 2015, Broadcom Corporation
 * All Rights Reserved.
 * 
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 *
 * $Id: wlc_btcx.h 557321 2015-05-18 17:56:25Z $
 */


#ifndef _wlc_btcx_h_
#define _wlc_btcx_h_

#define BTC_RXGAIN_FORCE_OFF            0
#define BTC_RXGAIN_FORCE_2G_MASK        0x1
#define BTC_RXGAIN_FORCE_2G_ON          0x1
#define BTC_RXGAIN_FORCE_5G_MASK        0x2
#define BTC_RXGAIN_FORCE_5G_ON          0x2

#define BT_RSSI_STEP	5
#define BT_RSSI_OFFSET	10
#define BT_RSSI_INVALID	0
#define BTC_BTRSSI_SIZE    8 /* max num of samples for moving average, must be 2^n */
#define BTC_BTRSSI_MIN_NUM  4 /* minimum number of btrssi samples for moving average */
#define BTC_BTRSSI_THRESH  (-70)
#define BTC_SISOACK_CORES_MASK  0x00FF
#define BTC_SISOACK_TXPWR_POS	8
#define BTC_SISOACK_TXPWR_MASK  0xFF00
#define BTC_SISOACK_QDBM_SHIFT	6
#define BTC_SISOACK_MAXPWR_FLD  0x0F00
#define BTC_SISOACK_CURPWR_POS  8
#define BTC_SISOACK_CURPWR_FLD  0xF000

/* BTCOEX profile data structures */
#define BTC_SUPPORT_BANDS	2

#define BTC_PROFILE_2G		0
#define BTC_PROFILE_5G		1

#define BTC_PROFILE_OFF		0
#define BTC_PROFILE_DISABLE 1
#define BTC_PROFILE_ENABLE	2

#define MAX_BT_DESENSE_LEVELS	8
#define BTC_WL_RSSI_DEFAULT -70
#define BTC_BT_RSSI_DEFAULT -70
#define BTC_WL_RSSI_HYST_DEFAULT_4350 5
#define BTC_BT_RSSI_HYST_DEFAULT_4350 5
#define MAX_BT_DESENSE_LEVELS_4350 2
#define BTC_WL_MAX_SISO_RESP_POWER_TDD_DEFAULT 127
#define BTC_WL_MAX_SISO_RESP_POWER_HYBRID_DEFAULT 127
#define BTC_WL_MAX_SISO_RESP_POWER_TDD_DEFAULT_4350 8
#define BTC_WL_MAX_SISO_RESP_POWER_HYBRID_DEFAULT_4350 16

/* BTCX config bits */
#define C_BTCX_CFG_LOW_RSSI_MASK	(1 << 7)
#define C_BTCX_CFG_LOW_RSSI_VAL		(1 << 7)
#define C_BTCX_CFG_LOW_RSSI_DFLT	0x00

#ifdef WLRSDB
/* COEX IO_MASK block */
typedef enum {
	COEX_IOMASK_TXCONF_POS = 0,
	COEX_IOMASK_PRISEL_POS = 1,
	COEX_IOMASK_WLPRIO_POS = 4,
	COEX_IOMASK_WLTXON_POS = 5
} coex_io_mask_t;
#endif /* WLRSDB */

typedef enum {
	C_BTCX_HFLG_NO_A2DP_BFR_NBIT	= 0, /* no check a2dp buffer */
	C_BTCX_HFLG_NO_CCK_NBIT			= 1, /* no cck rate for null or cts2self */
	C_BTCX_HFLG_NO_OFDM_FBR_NBIT	= 2, /* no ofdm fbr for null or cts2self */
	C_BTCX_HFLG_NO_INQ_DEF_NBIT		= 3, /* no defer inquery */
	C_BTCX_HFLG_GRANT_BT_NBIT		= 4, /* always grant bt */
	C_BTCX_HFLG_ANT2WL_NBIT			= 5, /* always prisel to wl */
	C_BTCX_HFLG_TXDATEN_NBIT		= 6, /* If dlna Allow Wlan TX during BT Tx slot */
	C_BTCX_HFLG_PS4ACL_NBIT			= 7, /* use ps null for unsniff acl */
	C_BTCX_HFLG_DYAGG_NBIT			= 8, /* dynamic tx agg durn */
	C_BTCX_HFLAG_4331_LMP_WAR		= 10, /* no LMP check for 4331(w 20702 A1/A3) */
} shm_btcx_hflg_t;

#define BTCX_HFLG_DLNA_MASK			(1 << C_BTCX_HFLG_ANT2WL_NBIT)
#define BTCX_HFLG_DLNA_DFLT_VAL		0x20
#define BTCX_HFLG_DLNA_TDM_VAL		0x0
#define BTCX_HFLG_DYAGG			0x0100  /* dynamic tx agg durn */

/* BTCDYN info */
typedef uint8 (* btcx_dynctl_calc_t)(wlc_info_t *wlc, int8 wl_rssi, int8 bt_pwr, int8 bt_rssi);

struct wlc_btcdyn_info {
	/* BTCOEX extension: adds dynamic desense & modes witching feature */
	uint16	bt_pwr_shm; /* last raw/per task bt_pwr read from ucode */
	int8	bt_pwr;		/* current bt power  */
	int8	wl_rssi;	/* last wl rssi */
	uint8	cur_dsns;	/* current desense level */
	dctl_prof_t *dprof; /* current board dynctl profile  */
					/* may be loaded from nvram txt or iovar */
	btcx_dynctl_calc_t desense_fn;	/* calculate desense level	*/
	btcx_dynctl_calc_t mswitch_fn;	/* calculate mode switch */
	/*	stimuli for dynctl dry runs(fake BT & WL activity) */
	int8	sim_btpwr;
	int8	sim_wlrssi;
	int8	sim_btrssi;
	/* mode switching hysteresis */
	int8 msw_btrssi_hyster; /* from bt rssi */
	/* dynamic tx power adjustment based on RSSI for hybrid coex */
	uint8	wlpwr_steps;
	uint8	padding[3];	/* can be reused */
	int8	*wlpwr_thresh;
	int8	*wlpwr_val;
};
typedef struct wlc_btcdyn_info wlc_btcdyn_info_t;


/* WLBTCPROF info */
struct wlc_btc_profile {
	uint32 mode;
	uint32 desense;
	int desense_level;
	int desense_thresh_high;
	int desense_thresh_low;
	uint32 num_chains;
	uint32 chain_ack[WL_NUM_TXCHAIN_MAX];
	int chain_power_offset[WL_NUM_TXCHAIN_MAX];
	int8 btc_wlrssi_thresh;
	uint8 btc_wlrssi_hyst;
	int8 btc_btrssi_thresh;
	uint8 btc_btrssi_hyst;
	uint8 btc_num_desense_levels;
	uint8 btc_siso_resp_en[MAX_BT_DESENSE_LEVELS];
	int8 btc_max_siso_resp_power[MAX_BT_DESENSE_LEVELS];
};
typedef struct wlc_btc_profile wlc_btc_profile_t;

struct wlc_btc_prev_connect {
	int prev_band;
	int prev_2G_mode;
	int prev_5G_mode;
	struct wlc_btc_profile prev_2G_profile;
	struct wlc_btc_profile prev_5G_profile;
};
typedef struct wlc_btc_prev_connect wlc_btc_prev_connect_t;


struct wlc_btc_select_profile {
	int enable;
	struct wlc_btc_profile select_profile;
};
typedef struct wlc_btc_select_profile wlc_btc_select_profile_t;

/* BTC stuff */
struct wlc_btc_info {
	wlc_info_t *wlc;
	uint16  bth_period;             /* bt coex period. read from shm. */
	bool    bth_active;             /* bt active session */
	uint8   prot_rssi_thresh;       /* rssi threshold for forcing protection */
	uint8   ampdutx_rssi_thresh;    /* rssi threshold to turn off ampdutx */
	uint8   ampdurx_rssi_thresh;    /* rssi threshold to turn off ampdurx */
	uint8   high_threshold;         /* threshold to switch to btc_mode 4 */
	uint8   low_threshold;          /* threshold to switch to btc_mode 1 */
	uint8   host_requested_pm;      /* saved pm state specified by host */
	uint8   mode_overridden;        /* override btc_mode for long range */
	/* cached value for btc in high driver to avoid frequent RPC calls */
	int     mode;
	int     wire;
	/* SISO ACK antenna (bits 0-7 specify core mask) */
	/* for btcdyn, bits 8-11: max siso ack power (dBm); bits 12-15: current power */
	uint16	siso_ack;
	uint8	padding[2];	/* can be reused */
	int     restage_rxgain_level;
	int     restage_rxgain_force;
	int     restage_rxgain_active;
	uint8   restage_rxgain_on_rssi_thresh;  /* rssi threshold to turn on rxgain restaging */
	uint8   restage_rxgain_off_rssi_thresh; /* rssi threshold to turn off rxgain restaging */
	uint16	agg_off_bm;
	int8	btrssi[BTC_BTRSSI_SIZE]; /* array of recent BT RSSI values */
	int16	btrssi_sum;	/*  bt rssi MA sum */
	uint8	btrssi_cnt;              /* number of btrssi samples */
	uint8	btrssi_idx;	/* index to bt_rssi sample array */
	int8	bt_rssi;	/* averaged bt rssi */
	uint16	bt_shm_addr;
	uint8	run_cnt;
	wlc_btcdyn_info_t *btcdyn; /* btcdyn info */
	wlc_bsscfg_t *cfg;	/* current 2G bsscfg */
	wlc_btc_prev_connect_t *btc_prev_connect; /* btc previous connection info */
	wlc_btc_select_profile_t *btc_profile; /* User selected profile for 2G and 5G params */
	wlc_btc_aibss_info_t *aibss_info; // AIBSS related cfg & status info
	int32	scb_handle;
	bool    simrx_slna;              /* simultaneous rx with shared fem/lna */
	int8	sco_rssi_thresh;	/* rssi threshold to reduce the  HOLDSCO limit */
	bool	hold_sco_status;	/* Used to optimize shm access 1: reduced Hold SCO limit */
	int8    dyagg;                   /* dynamic tx agg (1: on, 0: off, -1: auto) */
	uint16	bt_tasks_low;
	uint16	bt_tasks_hi;
	uint8	bt_task_read_cnt;
	uint8	bt_sco_on;
	uint8	bt_scan_on;
	uint8	bt_hid_on;
};

/* dynamic desense mode switching */
#ifdef WL_BTCDYN
#ifdef	DYNCTL_DBG
	#define BTCDBG(x) printf x
#else
	#define BTCDBG(x)
#endif /* DYNCTL_DBG */

/*  bit-field position/Mask in shm word */
#define SHM_BTC_MASK_TXPWR			0X7
#define SHM_BTC_SHFT_TXPWR_SCO		0
#define SHM_BTC_SHFT_TXPWR_A2DP		3
#define SHM_BTC_SHFT_TXPWR_SNIFF	6
#define SHM_BTC_SHFT_TXPWR_ACL		9
/*
	BT uses 3 bits to report current Tx power
	0 = invalid (no connection), 1 <= -12dBm, 2 = -8dBm,..., 6 = 8dBm, 7 >= 12dBm
	TxPwr = 3bitValue * TxPwrStep + TxPwrOffset, where TxPwrStep = 4 and TxPwrOffset = -16
*/
#define BT_TX_PWR_STEP				4
#define BT_TX_PWR_OFFSET			(-16)
#define BT_INVALID_TX_PWR			-127
#define BTCDYN_DFLT_BTRSSI_HYSTER	1

extern int btcx_set_ext_desense_calc(wlc_info_t *wlc, btcx_dynctl_calc_t cbfn);
extern int btcx_set_ext_mswitch_calc(wlc_info_t *wlc, btcx_dynctl_calc_t cbfn);
extern int btcx_init_dynctl_profile(wlc_info_t *wlc,  void *profile_data);
#endif /* WL_BTCDYN */

extern wlc_btc_info_t *wlc_btc_attach(wlc_info_t *wlc);
extern void wlc_btc_detach(wlc_btc_info_t *btc);
extern int wlc_btc_wire_get(wlc_info_t *wlc);
extern int wlc_btc_mode_get(wlc_info_t *wlc);
extern void wlc_enable_btc_ps_protection(wlc_info_t *wlc, wlc_bsscfg_t *bsscfg, bool protect);
extern uint wlc_btc_frag_threshold(wlc_info_t *wlc, struct scb *scb);
extern void wlc_btc_mode_sync(wlc_info_t *wlc);
extern uint8 wlc_btc_save_host_requested_pm(wlc_info_t *wlc, uint8 val);
extern bool wlc_btc_get_bth_active(wlc_info_t *wlc);
extern uint16 wlc_btc_get_bth_period(wlc_info_t *wlc);
extern void wlc_btc_4313_gpioctrl_init(wlc_info_t *wlc);
extern void wlc_btcx_read_btc_params(wlc_info_t *wlc);
extern int wlc_btc_params_set(wlc_info_t *wlc, int int_val, int int_val2);
extern int wlc_btc_params_get(wlc_info_t *wlc, int int_val);
extern bool wlc_btcx_pri_activity(wlc_info_t *wlc);
extern bool wlc_btc_turnoff_aggr(wlc_info_t *wlc);
extern bool wlc_btc_mode_not_parallel(int btc_mode);
extern bool wlc_btc_active(wlc_info_t *wlc);
extern void wlc_btc_hflg(wlc_info_t *wlc, bool set, uint16 val);
extern uint8 wlc_btcx_get_ba_rx_wsize(wlc_info_t *wlc);
extern void wlc_btc_ampdu_aggr(wlc_info_t *wlc, struct scb *scb, wlc_btc_info_t *btc);
#if defined(BCMDBG)
extern void wlc_btc_dump_status(wlc_info_t *wlc,  struct bcmstrbuf *b);
#endif
#ifdef WLRSDB
extern void wlc_btcx_update_coex_iomask(wlc_info_t *wlc);
extern bool wlc_btcx_rsdb_update_bt_chanspec(wlc_info_t *wlc);
#endif /* WLRSDB */


#ifdef WLBTCPROF

#define WL_BTCPROF WL_INFORM

extern int wlc_btc_profile_set(wlc_info_t *wlc, int int_val, int iovar_id);
extern int wlc_btc_profile_get(wlc_info_t *wlc, int iovar_id);
extern int wlc_btcx_select_profile_set(wlc_info_t *wlc, uint8 *pref, int len);
extern int wlc_btcx_select_profile_get(wlc_info_t *wlc, uint8 *pref, int len);
extern int wlc_btcx_set_btc_profile_param(struct wlc_info *wlc, chanspec_t chanspec, bool force);
extern int wlc_btcx_set_ext_profile_param(wlc_info_t *wlc);
extern int wlc_btcx_select_profile_set(wlc_info_t *wlc, uint8 *pref, int len);
extern int wlc_btcx_select_profile_get(wlc_info_t *wlc, uint8 *pref, int len);
#else
#define WL_BTCPROF WL_NONE
#endif /* WLBTCPROF */
#endif /* _wlc_btcx_h_ */
